<?php

namespace App\Models\Customer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'customer_service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contact()
    {
        return $this->hasMany('\App\Models\Customer\Contact');
    }

    public function filiale()
    {
        return $this->belongsTo('App\Models\Customer\Filiale');
    }

}